<?php
    /**
    *
    * copyright (c) 2013-2020 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    class VisualizzatoreRisorse extends VisualizzatoreComponente {
        private $tutteLeCategorie;
        private $idVisualizzatoreRisorse;
        private $filterList;

        function __construct($db) {
            parent::__construct($db);
            $this->tutteLeCategorie = ".nessunaCategoria, "; // questo spazio non va rimosso
        }
        
        function generaContenutoSezione($dati) {
            $visualizzatoreRisorse = parent::getDb()->leggiSingolaRiga("geec_visualizzatoriRisorse",$dati["idElemento"]);
            $this->idVisualizzatoreRisorse = "portfoliolist{$visualizzatoreRisorse["id"]}";
            $this->filterList		 = "filterlist{$visualizzatoreRisorse["id"]}";

            $classeContenitore = ($dati["aTuttaLarghezza"]=="si") ? "container-fluid" : "container";
            $classeSenzaBordi  = ($visualizzatoreRisorse["senzaBordi"]=="si") ? "no-gutters" : "";
            
            echo"<section id=\"{$dati["idSezione"]}\" class=\"portfolio {$dati["classeSezione"]}\">
                <div class=\"$classeContenitore\">
                    <div class=\"row\">
                        <div class=\"col-md-12 mb-3 text-center\">
                            <h2 class=\"separatore-inferiore\">{$visualizzatoreRisorse["nome"]}</h2>
                            <p class=\"lead\">{$visualizzatoreRisorse["descrizione"]}</p>
                        </div>
                        <div class=\"portfolioWrapper col risorse\">";

            if($visualizzatoreRisorse["categoria"]!=0) {
                $categoria = parent::getDb()->leggiSingolaRiga("geec_categorie",$visualizzatoreRisorse["categoria"]);
                $idCategoria = str_replace(" ", "", $categoria["nome"]);
                $this->tutteLeCategorie .= ".".$idCategoria;
            }
            else {
                /*
                 * Se il portfolio è di tipo filtrabile e ci sono categorie, viene creata
                 * una lista di elementi con tanti tag <li> per ogni categoria
                 * Ogni tag <li> contiene un tag span dove nel campo data-filter viene inserita
                 * la categoria
                 * 
                 * Il primo campo di questa lista è quello che contiene tutte le categorie, quindi
                 * viene creato per ultimo perché bisogna scorrere tutte le categorie che la query
                 * ha restituito. Nel ciclo while qui sotto vengono creati gli elementi e messi in un
                 * array e contemporaneamente viene aggiornata la variabile di classe @tutteLeCategorie
                 * che viene messa come data-filter nel campo "Tutto"
                 */
                $query="SELECT * FROM geec_categorie WHERE tipo LIKE 'risorsa'";
                $risCategoria = parent::getDb()->eseguiQueryLettura($query);
                if($risCategoria->num_rows>0) {
                    $arrayFiltri = array();
                    while($categoria=$risCategoria->fetch_assoc()) {
                        $idCategoria = str_replace(" ", "", $categoria["nome"]);
                        $arrayFiltri[count($arrayFiltri)] = "<li><span class=\"filter\" data-filter=\".$idCategoria\">{$categoria["nome"]}</span></li>";
                        $this->tutteLeCategorie .= ".$idCategoria, ";
                    }
                    $this->tutteLeCategorie = substr($this->tutteLeCategorie, 0, strlen($this->tutteLeCategorie)-2);
                }
                else {
                    $this->tutteLeCategorie = substr($this->tutteLeCategorie, 0, strlen($this->tutteLeCategorie)-2);
                }

                if($risCategoria->num_rows>0 && $visualizzatoreRisorse["filtrabile"]=="si") {
                    echo("<ul class=\"filters clearfix\">
                        <li><span class=\"filter active\" data-filter=\"$this->tutteLeCategorie\">Tutto</span></li>");
                        foreach($arrayFiltri as $filtro) {
                            echo($filtro);
                        }
                        echo"</ul>";
                }
                else {
                    echo"<ul class=\"filters \" style=\"display: none\">
                        <li><span class=\"filter active\" data-filter=\"$this->tutteLeCategorie\">Tutto</span></li>
                    </ul>";
                }
            }

            //costruzione della query secondo i criteri impostati dall'utente
            if(count($_SESSION["geecomUser_gruppiUtente"])>0) {
                $stringaGruppiUtenti = " OR id IN (SELECT idRisorsa FROM geecAd_gruppiDestinatari WHERE ";
                foreach($_SESSION["geecomUser_gruppiUtente"] as $gruppo) {
                    $stringaGruppiUtenti .= " idGruppoDestinatario=$gruppo OR ";
                }
                $stringaGruppiUtenti = substr($stringaGruppiUtenti, 0, -3).") ";
            }
            else {
                $stringaGruppiUtenti = "";
            }
            
            if($visualizzatoreRisorse["categoria"]==0) { // tutte le categorie
                $querySlide="SELECT * FROM geecAd_risorse WHERE accessibilita LIKE 'Globale' OR idUtente={$_SESSION["geecomUser_id"]} $stringaGruppiUtenti ORDER BY posizione ASC";
            }
            else { // solo la categoria selezionata
                $querySlide="SELECT * FROM geecAd_risorse WHERE accessibilita LIKE 'Globale' OR (idUtente={$_SESSION["geecomUser_id"]}) AND categoria={$visualizzatoreRisorse["categoria"]} $stringaGruppiUtenti ORDER BY posizione";
            }
            $risElementi = parent::getDb()->eseguiQueryLettura($querySlide);
            
            if($risElementi->num_rows==0) {
                echo("<h2>Attenzione, non sono presenti risorse. Caricarle dal pannello amministrativo</h2>");
            }
            
            echo("<div class=\"portfoliolist row mx-n3 $classeSenzaBordi\" id=\"$this->idVisualizzatoreRisorse\">");
            while($elemento=$risElementi->fetch_assoc()) {
                $categoria   = $this->getDb()->leggiSingolaRiga("geec_categorie",$elemento["categoria"]);
                $idCategoria = isset($categoria["nome"]) ? str_replace(" ", "", $categoria["nome"]) : "nessunaCategoria";
                $this->stampaRisorsa($elemento,$visualizzatoreRisorse["classeElementi"],$idCategoria);
            }
            echo("</div>");
            
            //chiudo il div carousel inner, creo le frecce e chiudo il div principale dello slider
                echo("</div>"
                . "</div>"
              . "</div>"
            . "</section>");
        }
        
        function stampaRisorsa($elemento,$classeBase,$idCategoria) {
            $dataCreazione = date("d/m/Y",strtotime(str_replace("/","-",$elemento["dataCreazione"])));
            if($elemento["immagine"]!="") {
                echo"<div class=\"$classeBase $idCategoria\" data-cat=\"$idCategoria\">
                    <div class=\"portfolio-wrapper p-3 bg-light\">
                        <div class=\"background-image aspect-ratio-16-9 mb-2\" style=\"background: url('{$elemento["immagine"]}')\"></div>
                        <h5 class=\"text-center\">{$elemento["nome"]}</h5>
                        <p class=\"text-muted\"><i class=\"fas fa-calendar-alt mr-2\"></i>$dataCreazione</p>
                        <p>{$elemento["descrizione"]}</p>
                        <a class=\"btn btn-primary  scarica\" href=\"scaricaFile.php?id={$elemento["id"]}\">Scarica </a>
                    </div>
                </div>";
            }
            else {
                echo"<div class=\"$classeBase $idCategoria\" data-cat=\"$idCategoria\">
                    <div class=\"portfolio-wrapper p-3 bg-light\">
                        <h5 class=\"text-center\">{$elemento["nome"]}</h5>
                        <p class=\"text-muted\"><i class=\"fas fa-calendar-alt mr-2\"></i>$dataCreazione</p>
                        <p>{$elemento["descrizione"]}</p>
                        <a class=\"btn btn-primary  scarica\" href=\"scaricaFile.php?id={$elemento["id"]}\">Scarica </a>
                    </div>
                </div>";
            }
        }

        function getJavascriptAssociato() {
            return"<script>
                $(function () {	
                    var $this->filterList = {
                        init: function () {
                            $('#$this->idVisualizzatoreRisorse').mixItUp({
                            selectors: {
                                target: '.portfolio',
                                filter: '.filter'	
                            },
                            load: {
                                  filter: '$this->tutteLeCategorie'  
                                }
                            });								
                        }
                    };
                    {$this->filterList}.init();
                });
            </script>";
        }
    }